<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Tambah Guru & Staf</title>

  <!-- BOOTSTRAP CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">

  <style>
    body{
      margin:0;
      font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial;
      background:#f5f7fb;
    }

    /* ===== SIDEBAR ASLI (DIPERTAHANKAN) ===== */
    .sidebar{width:280px;min-height:100vh;overflow-y:auto}
    .sidebar a{text-decoration:none}
    .sidebar .active{background:rgba(13,110,253,.12);border-radius:.5rem}
    .sub-menu{padding-left:1rem}
    .sub-menu .list-group-item{
      font-size:.9rem;
      padding:.5rem 1rem;
      border:none;
    }

    .menu-toggle{cursor:pointer;position:relative}
    .menu-toggle::after{
      content:'▼';
      position:absolute;
      right:1rem;
      font-size:.75rem;
      transition:.3s;
    }
    .menu-toggle.collapsed::after{transform:rotate(-90deg)}

    /* ===== RESPONSIVE ===== */
    .hamburger{
      display:none;
      font-size:1.6rem;
      color:#fff;
      cursor:pointer;
    }

    .sidebar-overlay{
      display:none;
      position:fixed;
      inset:0;
      background:rgba(0,0,0,.45);
      z-index:1040;
    }

    @media(max-width:991px){
      .hamburger{display:block}
      .sidebar{
        position:fixed;
        top:0;
        left:0;
        z-index:1050;
        background:#fff;
        transform:translateX(-100%);
        transition:.3s;
      }
      .sidebar.show{transform:translateX(0)}
      .sidebar-overlay.show{display:block}
    }

    /* ===== MAIN CONTENT FIX ===== */
    .main-content{
      flex:1;
      min-width:0;
    }

    .form-wrapper{
      max-width:720px;
    }

    .card{
      border-radius:16px;
      box-shadow:0 10px 25px rgba(0,0,0,.08);
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>

  <!-- MAIN -->
  <main class="main-content p-4">

    <h3 class="fw-bold mb-1">Tambah Guru & Staf</h3>
    <p class="text-muted mb-4">Isi data sesuai kartu galeri di website.</p>

    <?php if (!empty($errors)): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php foreach($errors as $e): ?>
            <li><?= esc($e) ?></li>
          <?php endforeach ?>
        </ul>
      </div>
    <?php endif ?>

    <div class="card p-4 form-wrapper">
      <form action="<?= site_url('admin/guru-staf/store') ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <div class="mb-3">
          <label class="form-label">Jabatan Utama *</label>
          <input class="form-control" name="jabatan_utama" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Label / Jabatan Tambahan</label>
          <input class="form-control" name="tags">
        </div>

        <div class="mb-3">
          <label class="form-label">Nama Lengkap *</label>
          <input class="form-control" name="nama" required>
        </div>

        <div class="mb-3">
          <label class="form-label">NIP</label>
          <input class="form-control" name="nip">
        </div>

        <div class="mb-3">
          <label class="form-label">Mapel / Bidang</label>
          <input class="form-control" name="mapel">
        </div>

        <div class="mb-3">
          <label class="form-label">Urutan *</label>
          <input type="number" class="form-control" name="urutan" value="99">
        </div>

        <div class="mb-4">
          <label class="form-label">Foto</label>
          <input type="file" class="form-control" name="foto" required>
        </div>

        <div class="d-flex gap-2">
          <button class="btn btn-primary">Simpan</button>
          <a href="<?= site_url('admin/guru-staf') ?>" class="btn btn-secondary">Batal</a>
        </div>
      </form>
    </div>

  </main>
</div>

<!-- BOOTSTRAP JS (WAJIB UNTUK COLLAPSE) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('show');
  document.querySelector('.sidebar-overlay').classList.toggle('show');
}
</script>

</body>
</html>
